/*
 * provide a mechanism for symbol translation
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "libfma.h"
#include "lf_internal.h"
#include "lf_symbols.h"

#define SYMTAB_INCREMENT 1024

void
lf_symtab_free(
  struct lf_symtab *sp)
{
  int i;

  if (sp != NULL) {
    if (sp->symbols != NULL) {
      for (i=0; i<sp->nsyms; ++i) {
	LF_FREE(sp->symbols[i]);
      }
      LF_FREE(sp->symbols);
    }
    LF_FREE(sp);
  }
}


struct lf_symtab *
lf_symtab_init()
{
  struct lf_symtab *stp;

  stp = (struct lf_symtab *) malloc(sizeof(*stp));
  assert(stp != NULL);

  stp->symtab_size = SYMTAB_INCREMENT;
  stp->nsyms = 0;
  stp->symbols = (char **) malloc(stp->symtab_size * sizeof(char *));
  assert(stp->symbols != NULL);

  return stp;
}

int
lf_symtab_lookup(
  struct lf_symtab *stp,
  char *symbol)
{
  int i;

  for (i=0; i<stp->nsyms; ++i) {
    if (strcmp(symbol, stp->symbols[i]) == 0) {
      return i;
    }
  }
  return -1;
}

int
lf_symtab_register(
  struct lf_symtab *stp,
  char *symbol)
{
  /* make sure this is not already registered */
  if (lf_symtab_lookup(stp, symbol) != -1) {
    return -1;
  }

  /* Need to grow? */
  while (stp->nsyms >= stp->symtab_size) {
    stp->symtab_size += SYMTAB_INCREMENT;
    stp->symbols = (char **) realloc(stp->symbols,
	stp->symtab_size * sizeof(char *));
    assert(stp->symbols != NULL);
  }

  /* Add the new symbol */
  stp->symbols[stp->nsyms] = (char *) malloc(strlen(symbol)+1);
  assert(stp->symbols[stp->nsyms] != NULL);
  strcpy(stp->symbols[stp->nsyms], symbol);

  /* return index to the new symbol */
  return stp->nsyms++;
}

int
lf_symtab_lookup_register(
  struct lf_symtab *stp,
  char *symbol)
{
  int i;

  i = lf_symtab_lookup(stp, symbol);
  if (i == -1) {
    i = lf_symtab_register(stp, symbol);
  }

 return i;
}
